<!-- ================== HERO SECTION ================== -->
<section id="hero" class="hero d-flex align-items-center">

  <style>
    /* ===== Premium Hero Design ===== */
    #hero {
      background: linear-gradient(135deg, #f8fafc, #eef2ff);
      padding: 110px 0 90px;
      overflow: hidden;
    }

    #hero h1 {
      font-size: 46px;
      font-weight: 900;
      line-height: 1.25;
      color: #0f172a;
    }

    #hero h2 {
      margin-top: 16px;
      font-size: 18px;
      line-height: 1.7;
      color: #475569;
      max-width: 520px;
    }

    #hero .btn-get-started {
      margin-top: 26px;
      padding: 14px 34px;
      border-radius: 50px;
      font-weight: 700;
      font-size: 15px;
      color: #fff;
      background: linear-gradient(120deg, #2563eb, #0ea5e9);
      box-shadow: 0 18px 40px rgba(37, 99, 235, 0.45);
      transition: 0.25s;
    }

    #hero .btn-get-started:hover {
      transform: translateY(-2px);
      box-shadow: 0 26px 55px rgba(37, 99, 235, 0.65);
    }

    #hero .hero-img img {
      max-width: 100%;
      border-radius: 28px;
      box-shadow: 0 30px 70px rgba(15, 23, 42, 0.25);
      transform: perspective(800px) rotateY(-8deg);
      transition: 0.4s ease;
    }

    #hero .hero-img img:hover {
      transform: perspective(800px) rotateY(0deg) scale(1.03);
    }

    /* ===== Mobile Responsive ===== */
    @media (max-width: 576px) {
      #hero {
        padding: 80px 0 70px;
        text-align: center;
      }

      #hero h1 {
        font-size: 30px;
      }

      #hero h2 {
        font-size: 15px;
        max-width: 100%;
      }

      #hero .btn-get-started {
        padding: 12px 28px;
        font-size: 14px;
      }

      #hero .hero-img img {
        margin-top: 30px;
        border-radius: 22px;
        transform: none;
      }
    }
  </style>

  <div class="container">
    <div class="row align-items-center">

      <div class="col-lg-6 d-flex flex-column justify-content-center">
        <h1 data-aos="fade-up">সহজ করুন আপনার পেমেন্ট ব্যবস্থাপনা</h1>

        <h2 data-aos="fade-up" data-aos-delay="400">
          ব্যবসায়িক পেমেন্ট ম্যানেজমেন্টকে করুন সহজ ও নিরাপদ—আজই আমাদের সাথে যুক্ত হোন।
        </h2>

        <div data-aos="fade-up" data-aos-delay="600" class="text-center text-lg-start">
          <a href="/sign-up"
             class="btn-get-started scrollto d-inline-flex align-items-center justify-content-center align-self-center">
            <span>Get Started</span>
            <i class="bi bi-arrow-right ms-2"></i>
          </a>
        </div>
      </div>

      <div class="col-lg-6 order-1 order-lg-2 hero-img text-center" data-aos="zoom-out">
        <img src="<?= base_url('public/assets/plat') ?>/payment-home-photo.png"
             class="img-fluid animated" alt="Hero Image">
      </div>

    </div>
  </div>

</section>
<!-- ================== END HERO SECTION ================== -->


<main id="main">

  <!-- ================== WE OFFER / VALUES SECTION ================== -->
  <section id="about" class="values">

    <style>
      /* ===== Premium Values Section ===== */

      #about {
        background: linear-gradient(180deg, #f8fafc, #eef2ff);
        padding: 90px 0;
      }

      #about .section-header h2 {
        font-size: 34px;
        font-weight: 900;
        text-align: center;
        color: #0f172a;
      }

      #about .section-header p {
        font-size: 16px;
        color: #475569;
        text-align: center;
        margin-bottom: 40px;
      }

      /* Card Box */
      #about .box {
        background: #ffffff;
        border-radius: 24px;
        padding: 26px 22px 30px;
        text-align: center;
        height: 100%;
        box-shadow: 0 18px 45px rgba(15, 23, 42, 0.14);
        border: 1px solid rgba(226, 232, 240, 0.95);
        transition: 0.25s ease;
        position: relative;
        overflow: hidden;
      }

      /* Hover glow */
      #about .box::before {
        content: "";
        position: absolute;
        inset: 0;
        background: radial-gradient(circle at top, rgba(37, 99, 235, 0.14), transparent 70%);
        opacity: 0;
        transition: 0.25s;
      }

      #about .box:hover::before {
        opacity: 1;
      }

      #about .box:hover {
        transform: translateY(-8px);
        box-shadow: 0 30px 75px rgba(15, 23, 42, 0.25);
      }

      /* Default image setup (overridden below for bigger image) */
      #about .box img {
        max-height: 90px;
        margin-bottom: 16px;
        object-fit: contain;
        filter: none;
        position: relative;
        z-index: 2;
      }

      /* Title */
      #about .box h3 {
        position: relative;
        z-index: 2;
        font-size: 18px;
        font-weight: 800;
        color: #0f172a;
        margin-bottom: 8px;
      }

      /* Text */
      #about .box p {
        position: relative;
        z-index: 2;
        font-size: 14px;
        color: #475569;
        line-height: 1.7;
        margin: 0;
      }

      /* Section responsive */
      @media (max-width: 991px) {
        #about {
          padding: 70px 0;
        }

        #about .section-header h2 {
          font-size: 28px;
        }
      }

      @media (max-width: 576px) {
        #about {
          padding: 60px 0;
        }

        #about .box {
          border-radius: 20px;
          padding: 22px 18px 26px;
        }

        #about .box img {
          max-height: 72px;
        }

        #about .box h3 {
          font-size: 16px;
        }

        #about .box p {
          font-size: 13.5px;
        }
      }

      /* ===== Image Bigger + Curve ===== */
      #about .box img {
        max-height: 130px;     /* বড় ইমেজ সাইজ */
        width: auto;
        margin-bottom: 18px;
        object-fit: contain;
        border-radius: 22px;   /* Curve design */
        padding: 10px;         /* White padding */
        background: #f8fafc;
        box-shadow: 0 12px 28px rgba(0, 0, 0, 0.12);
        transition: 0.25s ease;
      }

      /* Hover animation on image */
      #about .box:hover img {
        transform: scale(1.08) rotate(-1deg);
        box-shadow: 0 18px 40px rgba(0, 0, 0, 0.20);
      }

      /* Mobile Image Resize (override above for small screen) */
      @media (max-width: 576px) {
        #about .box img {
          max-height: 100px;
          border-radius: 18px;
          padding: 8px;
        }
      }
    </style>

    <div class="container" data-aos="fade-up">
      <header class="section-header">
        <h2>We Offer</h2>
        <p>Our guiding principles that empower seamless payment solutions</p>
      </header>

      <div class="row gy-4">

        <div class="col-lg-4 col-md-6">
          <div class="box">
            <img src="<?= base_url('public/assets/plat') ?>/tt.png" class="img-fluid" alt="">
            <h3>Save Time</h3>
            <p>Simplify your payment processes and save valuable time with our integrated MFS API, ensuring fast and efficient transactions.</p>
          </div>
        </div>

        <div class="col-lg-4 col-md-6">
          <div class="box">
            <img src="<?= base_url('public/assets/plat') ?>/nh.png" class="img-fluid" alt="">
            <h3>Seamless Integration</h3>
            <p>Easily connect and integrate with our system. Automate workflows, link applications, and manage data sources effortlessly.</p>
          </div>
        </div>

        <div class="col-lg-4 col-md-6">
          <div class="box">
            <img src="<?= base_url('public/assets/plat') ?>/mm.png" class="img-fluid" alt="">
            <h3>Automate Personal Accounts</h3>
            <p>Streamline your payment reception with Pay Online Bd automation. Direct payments to your personal account without manual intervention.</p>
          </div>
        </div>

        <div class="col-lg-4 col-md-6">
          <div class="box">
            <img src="<?= base_url('public/assets/plat') ?>/5644447.png" class="img-fluid" alt="">
            <h3>Invoice Generator</h3>
            <p>Create and send personalized payment links via email for quick and easy payments, eliminating the need for a website or online store.</p>
          </div>
        </div>

        <div class="col-lg-4 col-md-6">
          <div class="box">
            <img src="<?= base_url('public/assets/plat') ?>/6221918.png" class="img-fluid" alt="">
            <h3>Billing Management</h3>
            <p>Simplify billing with Pay In Pay Online Bd automated system. Monitor transactions, generate invoices, and streamline your billing process efficiently.</p>
          </div>
        </div>

        <div class="col-lg-4 col-md-6">
          <div class="box">
            <img src="<?= base_url('public/assets/plat') ?>/2903544.png" class="img-fluid" alt="">
            <h3>Multiple Payment Options</h3>
            <p>Offer your customers various payment methods, including Mobile Banking and Bank Transfers, through BD AUTO PAY versatile platform.</p>
          </div>
        </div>

      </div>
    </div>
  </section>
  <!-- ================== END VALUES SECTION ================== -->


  <!-- ================== COUNTS SECTION ================== -->
  <section id="counts" class="counts">

    <style>
      /* ===== Premium Counts Section ===== */

      #counts {
        background: linear-gradient(180deg, #f8fafc, #eef2ff);
        padding: 80px 0;
      }

      #counts .count-box {
        background: #ffffff;
        border-radius: 24px;
        padding: 22px 18px;
        text-align: left;
        position: relative;
        overflow: hidden;
        height: 100%;
        display: flex;
        align-items: center;
        gap: 14px;
        box-shadow: 0 20px 45px rgba(15, 23, 42, 0.16);
        border: 1px solid rgba(226, 232, 240, 0.9);
        transition: 0.25s ease;
      }

      #counts .count-box::before {
        content: "";
        position: absolute;
        inset: 0;
        background: radial-gradient(circle at top left, rgba(59, 130, 246, 0.18), transparent 60%);
        opacity: 0;
        transition: 0.25s;
      }

      #counts .count-box:hover::before {
        opacity: 1;
      }

      #counts .count-box:hover {
        transform: translateY(-6px);
        box-shadow: 0 26px 70px rgba(15, 23, 42, 0.25);
      }

      /* Icon */
      #counts .count-box i {
        position: relative;
        z-index: 2;
        font-size: 26px;
        width: 56px;
        height: 56px;
        border-radius: 18px;
        display: flex;
        align-items: center;
        justify-content: center;
        background: linear-gradient(135deg, #2563eb, #0ea5e9);
        color: #ffffff;
        box-shadow: 0 14px 32px rgba(37, 99, 235, 0.55);
      }

      /* Number */
      #counts .count-box span {
        position: relative;
        z-index: 2;
        display: block;
        font-size: 26px;
        font-weight: 800;
        color: #0f172a;
        line-height: 1.1;
      }

      /* Label */
      #counts .count-box p {
        position: relative;
        z-index: 2;
        margin: 4px 0 0;
        font-size: 13px;
        font-weight: 500;
        text-transform: uppercase;
        letter-spacing: 0.06em;
        color: #64748b;
      }

      /* Responsive */
      @media (max-width: 991px) {
        #counts {
          padding: 60px 0;
        }
      }

      @media (max-width: 576px) {
        #counts .count-box {
          padding: 18px 16px;
          border-radius: 18px;
        }

        #counts .count-box span {
          font-size: 22px;
        }

        #counts .count-box p {
          font-size: 12px;
        }

        #counts .count-box i {
          width: 50px;
          height: 50px;
          font-size: 22px;
        }
      }
    </style>

    <div class="container" data-aos="fade-up">
      <div class="row gy-4">

        <div class="col-lg-3 col-md-6">
          <div class="count-box">
            <i class="bi bi-people-fill"></i>
            <div>
              <span data-purecounter-start="0" data-purecounter-end="1963" data-purecounter-duration="1"
                    class="purecounter"></span>
              <p>Happy Clients</p>
            </div>
          </div>
        </div>

        <div class="col-lg-3 col-md-6">
          <div class="count-box">
            <i class="bi bi-book-half"></i>
            <div>
              <span data-purecounter-start="0" data-purecounter-end="6" data-purecounter-duration="1"
                    class="purecounter"></span>
              <p>Plans</p>
            </div>
          </div>
        </div>

        <div class="col-lg-3 col-md-6">
          <div class="count-box">
            <i class="bi bi-graph-up"></i>
            <div>
              <span data-purecounter-start="0" data-purecounter-end="3287490" data-purecounter-duration="1"
                    class="purecounter"></span>
              <p>Total Amount Transactions</p>
            </div>
          </div>
        </div>

        <div class="col-lg-3 col-md-6">
          <div class="count-box">
            <i class="bi bi-credit-card"></i>
            <div>
              <span data-purecounter-start="0" data-purecounter-end="12" data-purecounter-duration="1"
                    class="purecounter"></span>
              <p>Supported Payment Methods</p>
            </div>
          </div>
        </div>

      </div>
    </div>
  </section>
  <!-- ================== END COUNTS SECTION ================== -->


  <!-- ================== FEATURES SECTION ================== -->
  <section id="features" class="features">

    <style>
      /* ===== Premium Inline Features Design ===== */

      #features {
        background: #f8fafc;
        padding: 80px 0;
      }

      #features .section-header h2 {
        font-size: 34px;
        font-weight: 900;
        color: #0f172a;
      }

      #features .section-header p {
        font-size: 16px;
        color: #475569;
      }

      /* Left image card */
      #features .feature-image-wrapper {
        background: #ffffff;
        border-radius: 24px;
        padding: 14px;
        box-shadow: 0 22px 55px rgba(15, 23, 42, 0.18);
      }

      #features .feature-image-wrapper img {
        border-radius: 18px;
        width: 100%;
        height: auto;
        display: block;
      }

      /* Right side feature chips */
      #features .feature-box {
        background: #ffffff;
        border-radius: 999px;
        padding: 10px 16px;
        box-shadow: 0 12px 30px rgba(15, 23, 42, 0.10);
        font-size: 14px;
        color: #0f172a;
        margin-bottom: 10px;
        transition: 0.2s ease;
      }

      #features .feature-box i {
        font-size: 18px;
        margin-right: 8px;
        color: #2563eb;
      }

      #features .feature-box h3 {
        font-size: 14px;
        font-weight: 600;
        margin: 0;
      }

      /* hover effect */
      #features .feature-box:hover {
        transform: translateY(-3px);
        box-shadow: 0 18px 40px rgba(15, 23, 42, 0.20);
      }

      /* Responsive */
      @media (max-width: 991px) {
        #features {
          padding: 60px 0;
        }

        #features .section-header h2 {
          font-size: 28px;
        }

        #features .section-header p {
          font-size: 15px;
        }

        #features .feature-image-wrapper {
          margin-bottom: 24px;
        }
      }

      @media (max-width: 575px) {
        #features .feature-box {
          border-radius: 16px;
        }
      }
    </style>

    <div class="container" data-aos="fade-up">

      <header class="section-header">
        <h2>Features</h2>
        <p>Advanced capabilities for streamlined payments</p>
      </header>

      <div class="row align-items-center g-4">

        <!-- Left Image -->
        <div class="col-xl-6" data-aos="zoom-out" data-aos-delay="100">
          <div class="feature-image-wrapper">
            <img src="<?= base_url('public/assets/plat') ?>/13429923.jpg" class="img-fluid" alt="">
          </div>
        </div>

        <!-- Right Feature Chips -->
        <div class="col-lg-6 mt-3 mt-lg-0 d-flex">
          <div class="row align-self-center gy-3">

            <div class="col-md-6" data-aos="zoom-out" data-aos-delay="200">
              <div class="feature-box d-flex align-items-center">
                <i class="bi bi-speedometer2"></i>
                <h3>Real-Time Processing</h3>
              </div>
            </div>

            <div class="col-md-6" data-aos="zoom-out" data-aos-delay="300">
              <div class="feature-box d-flex align-items-center">
                <i class="bi bi-shield-lock"></i>
                <h3>High Security</h3>
              </div>
            </div>

            <div class="col-md-6" data-aos="zoom-out" data-aos-delay="400">
              <div class="feature-box d-flex align-items-center">
                <i class="bi bi-arrows-expand"></i>
                <h3>Scalability</h3>
              </div>
            </div>

            <div class="col-md-6" data-aos="zoom-out" data-aos-delay="600">
              <div class="feature-box d-flex align-items-center">
                <i class="bi bi-link"></i>
                <h3>Seamless Integration</h3>
              </div>
            </div>

            <div class="col-md-6" data-aos="zoom-out" data-aos-delay="700">
              <div class="feature-box d-flex align-items-center">
                <i class="bi bi-graph-up"></i>
                <h3>Comprehensive Reporting</h3>
              </div>
            </div>

            <div class="col-md-6" data-aos="zoom-out" data-aos-delay="800">
              <div class="feature-box d-flex align-items-center">
                <i class="bi bi-check-circle"></i>
                <h3>Automatic Payment Verification</h3>
              </div>
            </div>

            <div class="col-md-6" data-aos="zoom-out" data-aos-delay="900">
              <div class="feature-box d-flex align-items-center">
                <i class="bi bi-cash"></i>
                <h3>No Transaction Fees</h3>
              </div>
            </div>

          </div>
        </div>

      </div> <!-- / row -->

    </div>
  </section>
  <!-- ================== END FEATURES SECTION ================== -->


  <!-- ================== SERVICES SECTION ================== -->
  <section id="services" class="services">

    <style>
      /* ===== Responsive Premium Services ===== */
      #services {
        background: linear-gradient(180deg, #f8fafc, #eef2ff);
        padding: 80px 0;
      }

      #services .section-header h2 {
        font-size: 36px;
        font-weight: 900;
        color: #0f172a;
      }

      #services .section-header p {
        font-size: 17px;
        color: #475569;
      }

      /* Card */
      #services .service-box {
        background: #ffffff;
        border-radius: 20px;
        padding: 24px 20px;
        height: 100%;
        box-shadow: 0 20px 50px rgba(0, 0, 0, 0.12);
        transition: .3s;
        text-align: center;
      }

      #services .service-box:hover {
        transform: translateY(-8px);
        box-shadow: 0 35px 80px rgba(0, 0, 0, 0.22);
      }

      /* Icon */
      #services .service-box .icon {
        font-size: 28px;
        width: 64px;
        height: 64px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 16px;
        background: linear-gradient(135deg, #2563eb, #0ea5e9);
        color: #fff;
      }

      /* Title */
      #services .service-box h3 {
        font-size: 20px;
        font-weight: 800;
        color: #0f172a;
        margin-bottom: 10px;
      }

      /* Text */
      #services .service-box p {
        font-size: 14.5px;
        color: #475569;
        line-height: 1.7;
      }

      /* === Mobile Optimization === */
      @media (max-width: 768px) {
        #services {
          padding: 60px 0;
        }

        #services .section-header h2 {
          font-size: 30px;
        }

        #services .section-header p {
          font-size: 15px;
        }

        #services .service-box {
          padding: 20px 18px;
        }

        #services .service-box h3 {
          font-size: 18px;
        }

        #services .service-box p {
          font-size: 13.5px;
        }
      }
    </style>

    <div class="container" data-aos="fade-up">

      <header class="section-header text-center">
        <h2>Services</h2>
        <p>Explore our range of services</p>
      </header>

      <div class="row mt-5 g-4">

        <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="200">
          <div class="service-box">
            <i class="bi bi-lightning-charge-fill icon"></i>
            <h3>Instant Payment</h3>
            <p>After the customer makes the payment through Payonlinebd, it will be instantly added to account with automatic verification.</p>
          </div>
        </div>

        <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="300">
          <div class="service-box">
            <i class="bi bi-arrow-repeat icon"></i>
            <h3>Lifetime Updates</h3>
            <p>Enjoy free lifetime updates with the desired service.</p>
          </div>
        </div>

        <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="400">
          <div class="service-box">
            <i class="bi bi-wallet icon"></i>
            <h3>Unlimited Transactions</h3>
            <p>Receive unlimited payments with PAY Online Bd without any fees.</p>
          </div>
        </div>

        <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="500">
          <div class="service-box">
            <i class="bi bi-chat-dots icon"></i>
            <h3>24/7 Support</h3>
            <p>Our support team is available 24/7 to solve any issues, including PAY Online Bd setup and usage.</p>
          </div>
        </div>

        <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="600">
          <div class="service-box">
            <i class="bi bi-credit-card icon"></i>
            <h3>Payment Processing</h3>
            <p>Efficient and secure processing for all your payment needs, ensuring seamless transactions every time.</p>
          </div>
        </div>

        <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="700">
          <div class="service-box">
            <i class="bi bi-shield-check icon"></i>
            <h3>Fraud Prevention</h3>
            <p>Advanced fraud prevention measures to protect your business and customers from unauthorized activities.</p>
          </div>
        </div>

      </div>

    </div>
  </section>
  <!-- ================== END SERVICES SECTION ================== -->


  <!-- ================== PRICING SECTION ================== -->
  <section id="pricing" class="pricing">

    <style>
      /* ===== Premium Inline Pricing Design ===== */

      #pricing {
        background: linear-gradient(180deg, #f8fafc, #eef2ff);
        padding: 90px 0;
      }

      #pricing .section-header p {
        color: #475569;
      }

      #pricing .box {
        background: linear-gradient(145deg, #ffffff, #f1f5ff);
        border-radius: 22px;
        padding: 26px 22px;
        border: 1px solid #e2e8f0;
        box-shadow: 0 25px 60px rgba(15, 23, 42, 0.14);
        height: 100%;
        display: flex;
        flex-direction: column;
        position: relative;
        overflow: hidden;
        transition: all 0.25s ease;
      }

      #pricing .box::before {
        content: "";
        position: absolute;
        inset: 0;
        background: linear-gradient(120deg, rgba(37, 99, 235, 0.08), rgba(14, 165, 233, 0.08));
        opacity: 0;
        transition: 0.25s;
      }

      #pricing .box:hover::before {
        opacity: 1;
      }

      #pricing .box:hover {
        transform: translateY(-10px) scale(1.02);
        box-shadow: 0 35px 80px rgba(15, 23, 42, 0.25);
      }

      #pricing .box h3 {
        font-size: 22px;
        font-weight: 800;
        text-align: center;
        color: #0f172a;
        margin-bottom: 14px;
        position: relative;
        z-index: 2;
      }

      #pricing .price {
        font-size: 32px;
        font-weight: 900;
        text-align: center;
        color: #2563eb;
        position: relative;
        z-index: 2;
      }

      #pricing .price span {
        font-size: 13px;
        font-weight: 500;
        color: #475569;
      }

      #pricing p {
        font-size: 14px;
        color: #475569;
        margin-top: 12px;
        position: relative;
        z-index: 2;
      }

      #pricing ul {
        list-style: none;
        padding: 0;
        margin: 22px 0 26px;
        position: relative;
        z-index: 2;
      }

      #pricing ul li {
        font-size: 14px;
        color: #1e293b;
        padding: 8px 0;
        display: flex;
        gap: 10px;
        align-items: flex-start;
      }

      #pricing ul li::before {
        content: "✔";
        color: #16a34a;
        font-size: 14px;
        margin-top: 2px;
      }

      #pricing .btn-buy {
        margin-top: auto;
        text-align: center;
        display: inline-block;
        width: 100%;
        padding: 12px 0;
        border-radius: 999px;
        font-size: 14px;
        font-weight: 700;
        color: #ffffff;
        background: linear-gradient(120deg, #2563eb, #0ea5e9);
        box-shadow: 0 16px 40px rgba(37, 99, 235, 0.45);
        text-decoration: none;
        transition: 0.25s;
        position: relative;
        z-index: 2;
      }

      #pricing .btn-buy:hover {
        transform: translateY(-2px);
        box-shadow: 0 22px 55px rgba(37, 99, 235, 0.65);
      }

      /* ===== Responsive Pricing Title Text ===== */

      /* Desktop (Computer) */
      #pricing .section-header h2 {
        font-size: 42px;
        font-weight: 900;
      }

      #pricing .section-header p {
        font-size: 18px;
        margin-top: 10px;
        font-weight: 500;
      }

      /* Tablet */
      @media (max-width: 991px) {
        #pricing .section-header h2 {
          font-size: 34px;
        }

        #pricing .section-header p {
          font-size: 16px;
        }
      }

      /* Mobile */
      @media (max-width: 576px) {
        #pricing .section-header h2 {
          font-size: 28px;
        }

        #pricing .section-header p {
          font-size: 14px;
        }
      }
    </style>

    <div class="container" data-aos="fade-up">

      <header class="section-header">
        <h2>Pricing</h2>
        <p>Choose the plan that fits your business</p>
      </header>

      <div class="row gy-4 justify-content-center" data-aos="fade-left">

        <?php if (!empty($plans)) : foreach ($plans as $plan) : ?>
          <div class="col-lg-3 col-md-6">
            <div class="box">

              <h3><?= $plan['name'] ?></h3>

              <div class="price">
                <?= currency_format($plan['final_price']) ?>
                <span>/ <?= duration_type($plan['name'], $plan['duration_type'], $plan['duration'], false) ?></span>
              </div>

              <p class="text-center"><?= $plan['description'] ?></p>

              <ul>
                <li><?= plan_message('brand', $plan['brand']) ?></li>
                <li><?= plan_message('device', $plan['device']) ?></li>
                <li><?= plan_message('transaction', $plan['transaction']) ?></li>
              </ul>

              <a href="<?= user_url('plans') ?>" class="btn-buy">Buy Now</a>

            </div>
          </div>
        <?php endforeach;
        endif; ?>

      </div>

    </div>
  </section>
  <!-- ================== END PRICING SECTION ================== -->


  <!-- ================== SUPPORTED PLATFORMS SECTION ================== -->
  <section class="clients" id="platforms">

    <style>
      /* ===== Supported Platforms Final Premium Design ===== */

      #platforms {
        background: linear-gradient(180deg, #f8fafc, #eef2ff);
        padding: 70px 0;
      }

      /* Title */
      #platforms .section-header p {
        font-size: 30px;
        font-weight: 900;
        text-align: center;
        color: #0f172a;
        margin-bottom: 26px;
      }

      /* Wrapper gap control */
      #platforms .swiper-wrapper {
        column-gap: 6px;
      }

      /* Each Slide */
      #platforms .swiper-slide {
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 4px;
      }

      /* Logo Card Design */
      #platforms .swiper-slide img {
        max-width: 180px;
        max-height: 100px;
        object-fit: contain;
        background: #ffffff;
        padding: 8px;
        border-radius: 20px;
        box-shadow: 0 10px 28px rgba(15, 23, 42, 0.16);
        transition: 0.25s ease;
      }

      /* Hover effect */
      #platforms .swiper-slide img:hover {
        transform: scale(1.06);
        box-shadow: 0 18px 45px rgba(15, 23, 42, 0.25);
      }

      /* ===== Mobile Responsive ===== */
      @media (max-width: 576px) {
        #platforms {
          padding: 50px 0;
        }

        #platforms .section-header p {
          font-size: 22px;
          margin-bottom: 18px;
        }

        #platforms .swiper-slide {
          padding: 3px;
        }

        #platforms .swiper-slide img {
          max-width: 140px;
          max-height: 70px;
          padding: 6px;
          border-radius: 14px;
        }
      }
    </style>

    <div class="container" data-aos="fade-up">

      <header class="section-header">
        <p>Supported Platforms</p>
      </header>

      <div class="clients-slider swiper">
        <div class="swiper-wrapper align-items-center">

          <div class="swiper-slide">
            <img src="public/assets/plat/smm.png" class="img-fluid" alt="">
          </div>

          <div class="swiper-slide">
            <img src="public/assets/plat/php.png" class="img-fluid" alt="">
          </div>

          <div class="swiper-slide">
            <img src="public/assets/plat/javascript.png" class="img-fluid" alt="">
          </div>

          <div class="swiper-slide">
            <img src="public/assets/plat/jquery.png" class="img-fluid" alt="">
          </div>

          <div class="swiper-slide">
            <img src="public/assets/plat/nodejs.png" class="img-fluid" alt="">
          </div>

          <div class="swiper-slide">
            <img src="public/assets/plat/whmcs-logo.png" class="img-fluid" alt="">
          </div>

          <div class="swiper-slide">
            <img src="public/assets/plat/woocommerce-logo-transparent.png" class="img-fluid" alt="">
          </div>

          <div class="swiper-slide">
            <img src="public/assets/plat/wordpress-logo-stacked-rgb.png" class="img-fluid" alt="">
          </div>

        </div>

        <div class="swiper-pagination"></div>
      </div>

    </div>
  </section>
  <!-- ================== END SUPPORTED PLATFORMS SECTION ================== -->


  <!-- ================== F.A.Q SECTION ================== -->
  <section id="faq" class="faq">

    <style>
      /* ===== Premium FAQ Design ===== */

      #faq {
        background: linear-gradient(180deg, #eef2ff, #f8fafc);
        padding: 80px 0;
      }

      #faq .section-header h2 {
        font-size: 34px;
        font-weight: 900;
        color: #0f172a;
        text-align: center;
      }

      #faq .section-header p {
        font-size: 16px;
        color: #475569;
        text-align: center;
      }

      /* Accordion wrapper */
      #faq .accordion {
        background: transparent;
      }

      /* Single item card */
      #faq .accordion-item {
        border: none;
        margin-bottom: 14px;
        border-radius: 18px;
        overflow: hidden;
        box-shadow: 0 18px 40px rgba(15, 23, 42, 0.16);
        background: #ffffff;
      }

      /* Question button */
      #faq .accordion-button {
        background: #ffffff;
        color: #0f172a;
        font-weight: 600;
        font-size: 15px;
        padding: 14px 18px;
      }

      /* Arrow icon */
      #faq .accordion-button::after {
        filter: none;
      }

      /* Collapsed state */
      #faq .accordion-button.collapsed {
        box-shadow: none;
      }

      /* Answer text */
      #faq .accordion-body {
        font-size: 14px;
        line-height: 1.7;
        color: #475569;
        padding: 14px 18px 18px;
      }

      /* Remove default borders */
      #faq .accordion-item:last-of-type,
      #faq .accordion-item:first-of-type {
        border-radius: 18px;
      }

      /* Mobile responsive */
      @media (max-width: 991px) {
        #faq {
          padding: 60px 0;
        }

        #faq .section-header h2 {
          font-size: 28px;
        }

        #faq .section-header p {
          font-size: 15px;
        }
      }

      @media (max-width: 576px) {
        #faq .accordion-item {
          border-radius: 14px;
          box-shadow: 0 14px 28px rgba(15, 23, 42, 0.16);
        }

        #faq .accordion-button {
          font-size: 14px;
        }

        #faq .accordion-body {
          font-size: 13.5px;
        }
      }
    </style>

    <div class="container" data-aos="fade-up">

      <header class="section-header">
        <h2>F.A.Q</h2>
        <p>Frequently Asked Questions</p>
      </header>

      <?php if (!empty($items)) : ?>
        <div class="row">

          <!-- Left column -->
          <div class="col-lg-6">
            <div class="accordion accordion-flush" id="faqlist1">
              <?php
              $firstColumnItems = array_slice($items, 0, ceil(count($items) / 2));
              foreach ($firstColumnItems as $key => $item) : ?>
                <div class="accordion-item wow fadeInUp" data-wow-delay="0.1s">
                  <h2 class="accordion-header" id="m<?= $item['id'] ?>">
                    <button class="accordion-button collapsed"
                            type="button"
                            data-bs-toggle="collapse"
                            data-bs-target="#kkk<?= $item['id'] ?>"
                            aria-expanded="false"
                            aria-controls="kkk<?= $item['id'] ?>">
                      <?= $item['question'] ?>
                    </button>
                  </h2>
                  <div id="kkk<?= $item['id'] ?>"
                       class="accordion-collapse collapse"
                       aria-labelledby="m<?= $item['id'] ?>"
                       data-bs-parent="#faqlist1">
                    <div class="accordion-body">
                      <?= $item['answer'] ?>
                    </div>
                  </div>
                </div>
              <?php endforeach; ?>
            </div>
          </div>

          <!-- Right column -->
          <div class="col-lg-6">
            <div class="accordion accordion-flush" id="faqlist2">
              <?php
              $secondColumnItems = array_slice($items, ceil(count($items) / 2));
              foreach ($secondColumnItems as $key => $item) : ?>
                <div class="accordion-item wow fadeInUp" data-wow-delay="0.1s">
                  <h2 class="accordion-header" id="m<?= $item['id'] ?>">
                    <button class="accordion-button collapsed"
                            type="button"
                            data-bs-toggle="collapse"
                            data-bs-target="#kkk<?= $item['id'] ?>"
                            aria-expanded="false"
                            aria-controls="kkk<?= $item['id'] ?>">
                      <?= $item['question'] ?>
                    </button>
                  </h2>
                  <div id="kkk<?= $item['id'] ?>"
                       class="accordion-collapse collapse"
                       aria-labelledby="m<?= $item['id'] ?>"
                       data-bs-parent="#faqlist2">
                    <div class="accordion-body">
                      <?= $item['answer'] ?>
                    </div>
                  </div>
                </div>
              <?php endforeach; ?>
            </div>
          </div>

        </div>
      <?php endif; ?>

    </div>
  </section>
  <!-- ================== END F.A.Q SECTION ================== -->


  <!-- ================== SUPPORTED GATEWAYS SECTION ================== -->
  <section id="gateways" class="clients">

    <style>
      /* ===== Matched Premium Supported Gateways ===== */

      #gateways {
        background: linear-gradient(180deg, #f8fafc, #eef2ff);
        padding: 80px 0;
      }

      #gateways .section-header p {
        font-size: 30px;
        font-weight: 900;
        text-align: center;
        color: #0f172a;
        margin-bottom: 26px;
      }

      /* Swiper wrapper gap */
      #gateways .swiper-wrapper {
        column-gap: 6px;
      }

      /* Single slide */
      #gateways .swiper-slide {
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 6px;
      }

      /* Logo card */
      #gateways .swiper-slide img {
        max-width: 170px;
        max-height: 90px;
        object-fit: contain;
        background: #ffffff;
        padding: 12px 16px;
        border-radius: 22px;
        box-shadow: 0 16px 35px rgba(15, 23, 42, 0.15);
        border: 1px solid rgba(203, 213, 225, 0.9);
        transition: 0.25s ease;
        opacity: 1;
      }

      /* Hover effect */
      #gateways .swiper-slide img:hover {
        transform: scale(1.06) translateY(-2px);
        box-shadow: 0 24px 55px rgba(15, 23, 42, 0.25);
      }

      /* ===== Pagination Dots (Desktop only) ===== */
      #gateways .swiper-pagination {
        margin-top: 16px;
      }

      #gateways .swiper-pagination-bullet {
        width: 8px;
        height: 8px;
        margin: 0 3px;
        background: #94a3b8;
        opacity: 1;
      }

      #gateways .swiper-pagination-bullet-active {
        background: #2563eb;
      }

      /* ===== Mobile ===== */
      @media (max-width: 576px) {
        #gateways {
          padding: 60px 0;
        }

        #gateways .section-header p {
          font-size: 22px;
          margin-bottom: 18px;
        }

        #gateways .swiper-slide img {
          max-width: 140px;
          max-height: 70px;
          padding: 8px 10px;
          border-radius: 18px;
        }

        /* মোবাইলে ডট লুকানো */
        #gateways .swiper-pagination {
          display: none !important;
        }
      }
    </style>

    <div class="container" data-aos="fade-up">

      <header class="section-header">
        <p>Supported Gateways</p>
      </header>

      <div class="clients-slider swiper">
        <div class="swiper-wrapper align-items-center">

          <?php if (!empty($payments)) : foreach ($payments as $payment) : ?>
            <div class="swiper-slide">
              <img src="<?= base_url() . @get_value(get_value($payment['params'], 'option'), 'logo'); ?>"
                   class="img-fluid" alt="">
            </div>
          <?php endforeach;
          endif; ?>

        </div>
        <div class="swiper-pagination"></div>
      </div>

    </div>
  </section>
  <!-- ================== END SUPPORTED GATEWAYS SECTION ================== -->


  <!-- ================== CONTACT SECTION ================== -->
  <section id="contact" class="contact">

    <style>
      /* ===== Premium Contact Section ===== */

      #contact {
        background: linear-gradient(180deg, #eef2ff, #f8fafc);
        padding: 90px 0;
      }

      #contact .section-header p {
        font-size: 32px;
        font-weight: 900;
        text-align: center;
        color: #0f172a;
        margin-bottom: 40px;
      }

      /* Info card */
      #contact .info-box {
        background: #ffffff;
        padding: 28px 22px;
        border-radius: 22px;
        text-align: center;
        height: 100%;
        box-shadow: 0 20px 45px rgba(15, 23, 42, 0.15);
        border: 1px solid rgba(203, 213, 225, 0.9);
        transition: 0.25s ease;
      }

      #contact .info-box:hover {
        transform: translateY(-6px);
        box-shadow: 0 28px 60px rgba(15, 23, 42, 0.25);
      }

      /* Icon */
      #contact .info-box i {
        font-size: 32px;
        width: 64px;
        height: 64px;
        line-height: 64px;
        border-radius: 50%;
        color: #ffffff;
        background: linear-gradient(120deg, #2563eb, #0ea5e9);
        display: inline-block;
        margin-bottom: 14px;
        box-shadow: 0 10px 30px rgba(37, 99, 235, 0.45);
      }

      #contact .info-box h3 {
        font-size: 18px;
        font-weight: 800;
        color: #0f172a;
        margin-bottom: 6px;
      }

      #contact .info-box p {
        font-size: 14px;
        color: #475569;
        line-height: 1.6;
        margin: 0;
      }

      /* Mobile */
      @media (max-width: 991px) {
        #contact {
          padding: 70px 0;
        }

        #contact .section-header p {
          font-size: 26px;
          margin-bottom: 28px;
        }
      }

      @media (max-width: 576px) {
        #contact {
          padding: 60px 0;
        }

        #contact .section-header p {
          font-size: 22px;
        }

        #contact .info-box {
          padding: 22px 18px;
          border-radius: 18px;
        }

        #contact .info-box i {
          width: 56px;
          height: 56px;
          line-height: 56px;
          font-size: 26px;
        }

        #contact .info-box h3 {
          font-size: 16px;
        }

        #contact .info-box p {
          font-size: 13.5px;
        }
      }
    </style>

    <div class="container" data-aos="fade-up">

      <header class="section-header">
        <p>Contact Us</p>
      </header>

      <div class="row gy-4 justify-content-center">
        <div class="col-lg-8">

          <div class="row gy-4">

            <div class="col-md-6">
              <div class="info-box">
                <i class="bi bi-geo-alt"></i>
                <h3>Address</h3>
                <p><?= site_config('address') ?></p>
              </div>
            </div>

            <div class="col-md-6">
              <div class="info-box">
                <i class="bi bi-telephone"></i>
                <h3>Call Us</h3>
                <p><?= site_config('contact_tel') ?></p>
              </div>
            </div>

            <div class="col-md-6">
              <div class="info-box">
                <i class="bi bi-envelope"></i>
                <h3>Email Us</h3>
                <p><?= site_config('contact_email') ?></p>
              </div>
            </div>

            <div class="col-md-6">
              <div class="info-box">
                <i class="bi bi-clock"></i>
                <h3>Open Hours</h3>
                <p><?= site_config('contact_work_hour') ?></p>
              </div>
            </div>

          </div>

        </div>
      </div>

    </div>
  </section>
  <!-- ================== END CONTACT SECTION ================== -->

</main>
